/*
 * WebCam Widget by Todd Laney (ToddLa@HotMail.com)
 * modified from the Apple Developer example "Framing Gallery"
 * 
 * To add/modify the web cams edit the following files:
 *  WebCamList.js			list of all WebCams
 * 	Images/Logo.jpg			logo displayed on the Widget backside
 * 
 * 
 * May 23, 2005 Initial release.
 *
 * May 30, 2005 1.1 release 
 *      added AutoCycle
 *		added prev button
 *		added new artwork for next/prev
 *		show location and camera name at bottom of Widget
 *
 */


/*

Copyright _ 2005, Apple Computer, Inc.  All rights reserved.
NOTE:  Use of this source code is subject to the terms of the Software
License Agreement for Mac OS X, which accompanies the code.  Your use
of this source code signifies your agreement to such license terms and
conditions.  Except as expressly granted in the Software License Agreement
for Mac OS X, no other copyright, patent, or other intellectual property
license or right is granted, either expressly or by implication, by Apple.

*/

/*  JavaScript
 *  The implementation of your widget lies in the <script> portion of the HTML
 *  file. The widget object is provided by Dashboard for Dashbaord-specific 
 *  interaction, like working with preferences and certain event handlers. See
 *  the Dashboard documentation for more on these.
 */


//
// DEBUG code
// 
var debugMode = false;

// Write to the debug div when in Safari.
// Send a simple alert to Console when in Dashboard.
function DEBUG(str) {
	if (debugMode) {
		if (window.widget) {
			alert(str);
		} else {
			var debugDiv = document.getElementById('debugDiv');
			debugDiv.style.display = 'block';
			debugDiv.appendChild(document.createTextNode(str));
			debugDiv.appendChild(document.createElement("br"));
			debugDiv.scrollTop = debugDiv.scrollHeight;
		}
	}
}

// Global variables used throughout the JavaScript functions

var webcamURI = "";
var updateInterval = 60; // 1min -- if you change this change the default SELECTED in the HTML please
var AutoCycleFlag = false;

// constants describing the frame size and position

// size of the frame images
var FRAME_X = 29;
var FRAME_Y = 29;

// picture inset values, left, right, top, and bottom
var INSET_L = 16;
var INSET_R = 16;
var INSET_T = 16;
var INSET_B = 30;	// more room on the bottom to show the camera name, and next/prev/pref buttons

// frame width used on the picture, see #picture css
var BORDER_X = 1;
var BORDER_Y = 1;

// minimum and maximum allowed camera sizes
var CAM_MIN_W = 200;
var CAM_MIN_H = 225;
var CAM_MAX_W = 500;
var CAM_MAX_H = 500;

//The Knoxville cameras are out of proportion.

var KNOX_SCALE_FACTOR = 0.8;

// Resizes the "picture" and widget window when a new picture is added.
function resize(x,y)
{
	DEBUG("resize: " + x + "x" + y);
	
	var height = 0;
	var width = 0;
 
        if(x==0 && y==0) {
		DEBUG("*** Image size is 0,0 ***");
	    x = 400;
	    y = 300;
	}
	
	// if the image is larger than we want, we need to scale it down
	if(x >= CAM_MAX_W) {		
		y = Math.floor(y * (CAM_MAX_W/x));	 
		x = CAM_MAX_W;
	}
	
	if(y >= CAM_MAX_H) {			
		x = Math.floor(x * (CAM_MAX_H/y));
		y = CAM_MAX_H;
	}
	
	// if the image is smaller than we want, we need to scale it up
	if(x < CAM_MIN_W) {			
		y = Math.floor(y * (CAM_MIN_W/x));	
		x = CAM_MIN_W;
	}

	if(y < CAM_MIN_H) {			
		x = Math.floor(x * (CAM_MIN_H/y));
		y = CAM_MIN_H;
	}
	
	//This is to adjust for the Knoxville images being too "tall"
	y = KNOX_SCALE_FACTOR * x;

	// once the dimensions are determined, the "picture" <img> is sized accordingly

	document.picture.width = x;		
	document.picture.height = y;	
	document.picture.style.left = INSET_L;
	document.picture.style.top = INSET_T;
	
	// now resize the outer frame.
	height = y + BORDER_X * 2 + INSET_T + INSET_B;		
	width  = x + BORDER_Y * 2 + INSET_L + INSET_R;
		
	document.getElementById("TopEdge").style.width = width - FRAME_X*2;
	document.getElementById("LeftEdge").style.height = height - FRAME_Y*2;
	document.getElementById("RightEdge").style.height = height - FRAME_Y*2;
	document.getElementById("BottomEdge").style.width = width - FRAME_X*2;
	document.getElementById("Center").style.width = width - FRAME_X*2;
	document.getElementById("Center").style.height = height - FRAME_Y*2;
	
	// resize the back prefrences layer.
	document.getElementById("back").style.width = x;
	document.getElementById("back").style.height = y;
	
	DEBUG("window resize: " + window.innerWidth + "x" + window.innerHeight + " --> " + width + "x" + height);
	
	if (window.innerHeight != height)
	{
		DEBUG("***** window height is changing");
		// if the window changes height the next/prev buttons will move and we might miss a onmouseout event, so reset the images
		document.getElementById("prevButton").src = "Images/prev.png";
		document.getElementById("nextButton").src = "Images/next.png";
	}
	
	// work around a weird resize bug????
	if (window.widget && window.innerWidth == width && window.innerHeight > height)
	{
		DEBUG("***** window resize BUG?");
		window.resizeTo(width+1,height);		
	}
	
	if(window.widget) 						// you check to see if the widget is
	{										// running in Dashboard, and then
		window.resizeTo(width,height);		// resize the widget window
	}
}

var waitImage = null;
var waitTimer = null;

function drawWait()
{
	var wait = document.getElementById("wait");
	var context = wait.getContext("2d");
	
	context.clearRect (0, 0, wait.width, wait.height);
	
	//context.fillStyle = "rgba(0,192,32, 0.25)";
	//context.fillRect(0, 0, waitImage.width, waitImage.height);
	
	context.save();
	context.translate (waitImage.width/2, waitImage.height/2);
	context.rotate (((new Date).getTime() % 1000) * 1.0 * 2 * Math.PI / 1000.0);
	context.drawImage (waitImage, -waitImage.width/2, -waitImage.height/2, waitImage.width, waitImage.height);
	context.restore();
}

function startWait()
{
	if (waitImage == null)
	{
		waitImage = new Image();
		waitImage.src = "Images/Wait.png";
	}
	
	var wait = document.getElementById("wait");
	
	if (window.innerWidth > 0)
	{
		wait.style.left = (window.innerWidth - waitImage.width)/2;
		wait.style.top  = (window.innerHeight - waitImage.height)/2;
	}
	wait.style.opacity = 1.00;
	
	drawWait();
	if (waitTimer == null)
	{
		waitTimer = setInterval("drawWait();", 50);
	}
}

function stopWait()
{
	var wait = document.getElementById("wait");
	wait.style.opacity = 0.0;
	
	if (waitTimer)
	{
		clearInterval(waitTimer);
		waitTimer = null;
	}
}


// The resize event handler function.

function preResize()
{
	stopWait();
	// calls the resize function with the size of the new picture
	resize(parseInt(document.hiddenPic.width), parseInt(document.hiddenPic.height));
}

// Since this widget allows for multiple instances of itself, each needs
// to retain its own preferences.  Dashboard provides each widget with a 
// unique identifier that persists between logins.  This wrapper provides
// a property tied with the unique identifier.

function makeKey(key)
{
	return widget.identifier + "-" + key;
}

function updateCameraName()
{
	var list = document.getElementById("camLocation");		
	var strLocation = list.options[list.selectedIndex].text;	
	
	var list = document.getElementById("camPopup");		
	var strCameraName = list.options[list.selectedIndex].text;	
	
	if (strLocation != "All")
		strCameraName = strLocation + " - " + strCameraName;
		
	DEBUG("***** CAMERA NAME: " + strCameraName);
	document.getElementById("CameraName").innerText = strCameraName;		
}

function setPicture(uri)
{	
	DEBUG("setPicture(" + uri + ")");

	startWait();
	
	var img = document.getElementById ("picture");			
	var img2 = document.getElementById ("hiddenPic");		
	img.onload = preResize;									
	
	var time = (new Date).getTime();
	img.src = img2.src = uri + "?t=" + time;	
	
	if (webcamURI != uri)
	{
		webcamURI = uri;
		
		if(window.widget)
		{
			widget.setPreferenceForKey(uri,makeKey("Image"));	
		}
		
		updateCameraName();
	}
}

function setAutoCycle(flag)
{
	DEBUG("setAutoCycle(" + flag + ")");
	AutoCycleFlag = flag;
	if(window.widget)
	{
		widget.setPreferenceForKey(AutoCycleFlag ? "Yes" : "No",makeKey("AutoCycle"));	
	}	
}

function setUpdateTime(time)
{
	DEBUG("setUpdateTime(" + time + ")");

	if (time > 0)
	{
		updateInterval= time;
		
		if(window.widget)
		{
			widget.setPreferenceForKey(time,makeKey("UpdateTime"));	
		}	
		
		onhide();
		onshow();
	}
}

function setCam(step)
{
	var list = document.getElementById("camPopup");
	var i = list.selectedIndex + step;
	
	if (i < 0) i = list.length-1;
	if (i >= list.length) i = 0;
	
	list.selectedIndex = i;
	setPicture(list.options[list.selectedIndex].value);
}

function nextCam()     {setCam(+1);}
function prevCam()     {setCam(-1);}

function updateCam()   
{
	DEBUG("updateCam()"); 
	
	if (front.style.display == "none")
	{
		DEBUG("updateCam() ignored");
		return;
	}
	
	if (AutoCycleFlag)
		setCam(1);
	else
		setCam(0);
}

//
// called when a location is selected.  the list of location specific web cams is placed in the "camPopup" listbox
//
function setLocation(strLocation, update)
{
	var strPrefix = "";
	
	DEBUG("setLocation(" + strLocation + "," + update +")");
	
	// fill web cam list box
	var list = document.getElementById("camPopup");
	list.length = 0;
	
	for (i = 0; i<WebCamList.length && WebCamList[i] != ""; i += 2)
	{
		if (WebCamList[i+1] == "" && (WebCamList[i] == strLocation || strLocation == "All"))
		{
			if (strLocation == "All")
			{
				strPrefix = WebCamList[i] + " - ";
			}
			
			for (i+=2; WebCamList[i+1] != "" && i < WebCamList.length; i+=2)
			{
				list.options[list.length] = new Option(strPrefix + WebCamList[i], WebCamList[i+1]);
			}
			i -= 2;
		}
	}
	
	if (update)
	{
		if(window.widget)
		{
			widget.setPreferenceForKey(strLocation,makeKey("Location"));	
		}	
	
		setPicture(list.options[0].value);
	}
}

// The setup function is called upon the loading of the widget.  It initializes
// the various elements of the widget if they have preferences.  If not, the default
// settings are used.

function setup()
{
	DEBUG("setup()");
	
	// fill Location list box
	var list = document.getElementById("camLocation");
	list.length = 0;

	for (i = 0; i<WebCamList.length; i += 2)
	{
		if (WebCamList[i] != "" && WebCamList[i+1] == "")
		{
			list.options[list.length] = new Option(WebCamList[i], WebCamList[i]);
		}
	}
	list.options[list.length] = new Option("All", "All");
	
	// set default location, this will fill the camera list for the first time.
	setLocation(list.options[0].value, false);
	
	if(window.widget)
	{
		var strLocation = widget.preferenceForKey(makeKey("Location"));
		
		if (strLocation && strLocation.length > 0)
		{
			// restore the selection in the location listbox
			setLocation(strLocation, false);
			
			var list = document.getElementById("camLocation");

			for (i=0; i<list.length; i++)
			{
				if (list.options[i].value == strLocation)
					list.selectedIndex = i;
			}
		}
	
		// The image preferences are retrieved:
		var list = document.getElementById("camPopup");

		var picturesrc = widget.preferenceForKey(makeKey("Image"));
		
		if (picturesrc == null || picturesrc.length == 0)
		{
		    picturesrc = list.options[list.selectedIndex].value;
		}
		else
		{
			for (i=0; i<list.length; i++)
			{
				if (list.options[i].value == picturesrc)
					list.selectedIndex = i;
			}
		}
		
		//webcamURI = picturesrc; // setPicture(picturesrc);							
		
		// get update interval
		var strUpdateTime = widget.preferenceForKey(makeKey("UpdateTime"));
		
		if (strUpdateTime && strUpdateTime.length > 0)
		{
			updateInterval = parseInt(strUpdateTime);
			
			var list = document.getElementById("UpdateTimePopup");
			
			for (i=0; i<list.length; i++)
			{
				if (list.options[i].value == updateInterval)
					list.selectedIndex = i;
			}
		}
		
		// get AutoCycle
		AutoCycleFlag = widget.preferenceForKey(makeKey("AutoCycle")) == "Yes";
		document.getElementById("AutoCycle").checked = AutoCycleFlag;
		
		// call onshow to set update timer and update image now
		onshow();
	}
	else
	{
		var list = document.getElementById("camPopup");
		webcamURI = list.options[0].value; 
		onshow();						
	}
}

// The showPrefs function is called when the preferences button is clicked.  It prepares
// the widget to show the preferences, and then flips them.  More on this can be found in
// the Dashboard documentation.

function showPrefs()
{
	var front = document.getElementById("front");		// first, you need to get the front
	var back = document.getElementById("back");			// and back layers
	
	if(window.widget)									// this freezes the currently visible
		widget.prepareForTransition("ToBack");			// layer
	
	front.style.display="none";							// the preferences layer is made
	back.style.display="block";							// visible and the picture is hidden
				
	if(window.widget)									// the flip transition is run, with the
		setTimeout ('widget.performTransition();', 0);	// frozen side on the front and the
														// preferences on the back
}

// When the "Done" button is clicked in the preferences, this function is called. It swaps
// the preference layer out with the picture and frame.

function hidePrefs()
{
	var front = document.getElementById("front");		// again, you need to obtain the front
	var back = document.getElementById("back");			// and back layers
	
	if (window.widget)									// then freeze the visible layer (as seen
		widget.prepareForTransition("ToFront");			// by the user
	
	front.style.display="block";						// hide the preferences layer and shot the 
	back.style.display="none";							// main picture layer
	
	if (window.widget)									// and run the flip transition; note that since
		setTimeout ('widget.performTransition();', 0);	// finishEdit() was used to freeze the UI, this 
}														// the widget in the opposite direction


// Preferences button animation
// These functions are used to animate the appearance and disappearance of the the preferences 
// button on the front side of the widget.

var flipShown = false;

// A structure that holds information that is needed for the animation to run.
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, theElement:null, timer:null};

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

// animate() performs the fade animation for the preferences flipper and the DnD indicator. It uses the opacity CSS property.
function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.theElement.style.opacity = animation.now;
}

// mousemove() is triggered whenever a mouse is moved within the bounds of your widget.  It's used
// here to prep the preference flipper fade when the mouse first enters the widget boundries.
function mousemove (event)
{
	if (!flipShown)
	{
		DEBUG("mousemove(): flipShown = " + flipShown);
	
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; // set it back one frame
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.theElement = document.getElementById ('UI');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 1.0;
		animate();
		flipShown = true;
	}
}

// mouseexit() is the opposite of mousemove() in that it preps the preferences flipper and DnD indicator
// to disappear.  It adds the appropriate values to the animation data structure and sets the animation in motion
function mouseexit (event)
{
	if (flipShown)
	{
		DEBUG("mouseexit(): flipShown = " + flipShown);
	
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; // set it back one frame
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.theElement = document.getElementById ('UI');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}

// onremove clears away any preferences that this widget may have had.
function onremove()
{
	DEBUG("onremove");
	widget.setPreferenceForKey(null,makeKey("Image"));
	widget.setPreferenceForKey(null,makeKey("UpdateTime"));
	widget.setPreferenceForKey(null,makeKey("Location"));
	widget.setPreferenceForKey(null,makeKey("AutoCycle"));
}

var updateTimer = null;

function onshow() 
{
	DEBUG("onshow() updateInterval = " + updateInterval);
	
    if (updateTimer == null) 
	{
		updateCam();
        updateTimer = setInterval("updateCam();", updateInterval * 1000);
    }
}

function onhide()
{
	DEBUG("onhide()");
	
    if (updateTimer != null) 
	{
        clearInterval(updateTimer);
        updateTimer = null;
    }
}

// this is where widget-specific handlers can be declared.  This widget only uses one;
// it is called when the widget is removed from Dashbaord

if(window.widget)
{
	widget.onremove = onremove;
	widget.onhide = onhide;
	widget.onshow = onshow;
}

